/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.taxud.cesop.validation;

import eu.europa.ec.taxud.cesop.domain.DocTypeEnum;
import eu.europa.ec.taxud.cesop.domain.MessageTypeIndicEnum;
import eu.europa.ec.taxud.cesop.domain.PaymentDataMsgPartContentType;
import eu.europa.ec.taxud.cesop.domain.ValidationError;
import eu.europa.ec.taxud.cesop.domain.XmlCountryTypeAndValue;
import eu.europa.ec.taxud.cesop.domain.XmlMessageSpec;
import eu.europa.ec.taxud.cesop.domain.XmlPaymentDataMsgPart;
import eu.europa.ec.taxud.cesop.domain.XmlPsp;
import eu.europa.ec.taxud.cesop.domain.XmlReportedPayee;
import eu.europa.ec.taxud.cesop.domain.XmlReportedTransaction;
import eu.europa.ec.taxud.cesop.domain.XmlTypeAndValue;
import eu.europa.ec.taxud.cesop.readers.IPspXmlReader;
import eu.europa.ec.taxud.cesop.utils.ValidationErrorUtils;
import eu.europa.ec.taxud.cesop.validation.CesopValidationErrorList;
import eu.europa.ec.taxud.cesop.validation.ValidationSettings;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;

public class PspValidatingReader {
    private final IPspXmlReader xmlReader;
    private final ValidationSettings settings;
    private final List<ValidationError> validationErrors;
    private final Set<String> transactionIdentifiersSet;
    private final Set<String> docRefSet;
    private final HashMap<Set<XmlTypeAndValue>, String> reportedPayeeSet;
    private final Set<String> corDocRefIds;
    private final boolean checkBRs;

    public PspValidatingReader(IPspXmlReader xmlReader, ValidationSettings settings, boolean checkBRs, Set<String> corDocRefIds) {
        this.settings = settings;
        this.xmlReader = xmlReader;
        this.validationErrors = new CesopValidationErrorList(settings.getMaxErrors());
        this.transactionIdentifiersSet = new HashSet<String>();
        this.docRefSet = new HashSet<String>();
        this.reportedPayeeSet = new HashMap();
        this.corDocRefIds = corDocRefIds;
        this.checkBRs = checkBRs;
        if (checkBRs) {
            this.validateHeader();
        }
    }

    private void validateHeader() {
        XmlMessageSpec xmlMessageSpec = this.xmlReader.getXmlMessageSpec();
        String messageRefId = xmlMessageSpec.getMessageRefId();
        ValidationErrorUtils.checkMhBr0030(this.validationErrors, messageRefId, xmlMessageSpec.getReportingPeriod(), this.settings.getBusinessMinPeriod());
        ValidationErrorUtils.checkCmTr0070(this.validationErrors, messageRefId, this.xmlReader.getEstimatedContentSize(), this.settings.getMaxSize());
        ValidationErrorUtils.checkMhBr0110(this.validationErrors, messageRefId, xmlMessageSpec.getCorrMessageRefId(), xmlMessageSpec.getMessageTypeIndic());
        ValidationErrorUtils.checkMhBr0090(this.validationErrors, messageRefId, xmlMessageSpec.getMessageType(), this.xmlReader.getXmlReportingPsp() != null);
    }

    public List<ValidationError> getValidationErrors() {
        return this.validationErrors;
    }

    public Iterator<XmlPaymentDataMsgPart> validateParts() {
        return new Iterator<XmlPaymentDataMsgPart>(){
            int errorsBeforeCurrentPayee;
            boolean emptyTransactionsCurrentPayee = true;
            {
                if (PspValidatingReader.this.checkBRs) {
                    XmlPsp sendingPsp;
                    MessageTypeIndicEnum messageTypeIndic = PspValidatingReader.this.xmlReader.getXmlMessageSpec().getMessageTypeIndic();
                    String messageRefId = PspValidatingReader.this.xmlReader.getXmlMessageSpec().getMessageRefId();
                    if (PspValidatingReader.this.xmlReader.getXmlReportingPsp() != null) {
                        ValidationErrorUtils.checkCmBr0100(PspValidatingReader.this.validationErrors, messageRefId, PspValidatingReader.this.xmlReader.getXmlReportingPsp().getPspId());
                        ValidationErrorUtils.checkCmBr0130(PspValidatingReader.this.validationErrors, messageRefId, PspValidatingReader.this.xmlReader.getXmlReportingPsp().getPspId().getType(), PspValidatingReader.this.xmlReader.getXmlReportingPsp().getPspId().getOther(), PspValidatingReader.this.xmlReader.getXmlMessageSpec().getXsdVersion());
                        if (this.hasNext()) {
                            ValidationErrorUtils.checkRpBr0040(PspValidatingReader.this.validationErrors, messageRefId, true, messageTypeIndic);
                        } else {
                            XmlMessageSpec messageSpec = PspValidatingReader.this.xmlReader.getXmlMessageSpec();
                            ValidationErrorUtils.checkCmBr0110(PspValidatingReader.this.validationErrors, messageSpec.getMessageRefId(), messageSpec.getMessageTypeIndic());
                        }
                    }
                    if ((sendingPsp = PspValidatingReader.this.xmlReader.getXmlMessageSpec().getSendingPsp()) != null && sendingPsp.getPspId() != null) {
                        ValidationErrorUtils.checkCmBr0130(PspValidatingReader.this.validationErrors, messageRefId, sendingPsp.getPspId().getType(), sendingPsp.getPspId().getOther(), PspValidatingReader.this.xmlReader.getXmlMessageSpec().getXsdVersion());
                    }
                }
                this.errorsBeforeCurrentPayee = PspValidatingReader.this.validationErrors.size();
            }

            @Override
            public boolean hasNext() {
                return PspValidatingReader.this.xmlReader.hasNext();
            }

            @Override
            public XmlPaymentDataMsgPart next() {
                XmlPaymentDataMsgPart next = PspValidatingReader.this.xmlReader.next();
                if (next.getContentType() == PaymentDataMsgPartContentType.REPORTED_TRANSACTIONS) {
                    int errCount = PspValidatingReader.this.validationErrors.size();
                    this.emptyTransactionsCurrentPayee = next.getXmlReportedTransactions().isEmpty();
                    if (PspValidatingReader.this.checkBRs) {
                        PspValidatingReader.this.validateReportedTransactions(next);
                    }
                    if (PspValidatingReader.this.validationErrors.size() > errCount) {
                        next.setError(true);
                    }
                } else {
                    if (PspValidatingReader.this.checkBRs) {
                        PspValidatingReader.this.validateReportedPayee(next, this.emptyTransactionsCurrentPayee);
                    }
                    if (PspValidatingReader.this.validationErrors.size() > this.errorsBeforeCurrentPayee) {
                        next.setError(true);
                    }
                    String docRefId = next.getXmlReportedPayee().getDocSpec().getDocRefId();
                    PspValidatingReader.this.validationErrors.stream().skip(this.errorsBeforeCurrentPayee).forEach(err -> err.setDocRefId(docRefId));
                    this.errorsBeforeCurrentPayee = PspValidatingReader.this.validationErrors.size();
                    this.emptyTransactionsCurrentPayee = true;
                }
                return next;
            }
        };
    }

    private void validateReportedPayee(XmlPaymentDataMsgPart paymentDataMsgPart, boolean emptyTransactions) {
        String messageRefId = this.xmlReader.getXmlMessageSpec().getMessageRefId();
        MessageTypeIndicEnum messageTypeIndic = this.xmlReader.getXmlMessageSpec().getMessageTypeIndic();
        XmlReportedPayee xmlReportedPayee = paymentDataMsgPart.getXmlReportedPayee();
        DocTypeEnum docType = DocTypeEnum.findByCode(xmlReportedPayee.getDocSpec().getDocTypeIndic());
        String docRefId = xmlReportedPayee.getDocSpec().getDocRefId();
        List<XmlCountryTypeAndValue> accounts = xmlReportedPayee.getAccountIdentifiers();
        String xsdVersion = this.xmlReader.getXmlMessageSpec().getXsdVersion();
        accounts.forEach(account -> {
            ValidationErrorUtils.checkRpBr0060(this.validationErrors, account, messageRefId);
            ValidationErrorUtils.checkCmBr0140(this.validationErrors, messageRefId, account.getType(), account.getOther(), xsdVersion);
            ValidationErrorUtils.checkRpBr0110(this.validationErrors, messageRefId, account.getType(), account.getOther(), xsdVersion);
        });
        ValidationErrorUtils.checkRpBr0100(this.validationErrors, accounts, messageRefId, docRefId, xsdVersion);
        ValidationErrorUtils.checkCmBr0150(this.validationErrors, messageRefId, this.reportedPayeeSet, xmlReportedPayee.getNames(), accounts, docRefId);
        ValidationErrorUtils.checkRpBr0050(this.validationErrors, messageRefId, docType, emptyTransactions);
        ValidationErrorUtils.checkCmBr0010(this.validationErrors, messageRefId, this.docRefSet, docRefId);
        ValidationErrorUtils.checkMhBr0070AndMhBr0080(this.validationErrors, messageRefId, messageTypeIndic, docType, docRefId);
        String corrDocRefId = xmlReportedPayee.getDocSpec().getCorrDocRefId();
        ValidationErrorUtils.checkCmBr0050(this.validationErrors, messageRefId, docType, corrDocRefId, docRefId);
        ValidationErrorUtils.checkCmBr0060(this.validationErrors, messageRefId, docType, corrDocRefId, docRefId);
        ValidationErrorUtils.checkCmBr0120(this.validationErrors, messageRefId, docType, corrDocRefId, this.corDocRefIds, xsdVersion, docRefId);
        accounts.forEach(account -> {
            if (ValidationErrorUtils.checkRpBr0020(this.validationErrors, messageRefId, account.getType(), account.getValue(), docRefId)) {
                ValidationErrorUtils.checkRpBr0030(this.validationErrors, messageRefId, account.getType(), account.getValue(), docRefId);
            }
        });
        XmlPsp representative = xmlReportedPayee.getRepresentative();
        if (representative != null) {
            ValidationErrorUtils.checkRpBr0070(this.validationErrors, messageRefId, representative.getPspId(), docRefId);
            ValidationErrorUtils.checkCmBr0140(this.validationErrors, messageRefId, representative.getPspId().getType(), representative.getPspId().getOther(), xsdVersion);
        }
        XmlCountryTypeAndValue accountIdentifier = accounts.stream().filter(v -> v.getValue() != null && !v.getValue().isEmpty()).findFirst().orElse(null);
        ValidationErrorUtils.checkRpBr0080(this.validationErrors, messageRefId, accountIdentifier, representative, docRefId);
        ValidationErrorUtils.checkRpBr0090(this.validationErrors, messageRefId, docType, emptyTransactions, docRefId, xsdVersion);
        if (xmlReportedPayee.getTaxIdentifications() != null) {
            xmlReportedPayee.getTaxIdentifications().forEach(t -> ValidationErrorUtils.checkCmBr0140(this.validationErrors, messageRefId, t.getType(), t.getOther(), xsdVersion));
        }
    }

    private void validateReportedTransactions(XmlPaymentDataMsgPart paymentDataMsgPart) {
        String messageRefId = this.xmlReader.getXmlMessageSpec().getMessageRefId();
        Integer reportingPeriod = this.xmlReader.getXmlMessageSpec().getReportingPeriod();
        String xsdVersion = this.xmlReader.getXmlMessageSpec().getXsdVersion();
        List<XmlReportedTransaction> xmlReportedTransactions = paymentDataMsgPart.getXmlReportedTransactions();
        for (XmlReportedTransaction xmlReportedTransaction : xmlReportedTransactions) {
            String transactionIdentifier = xmlReportedTransaction.getTransactionIdentifier();
            ValidationErrorUtils.checkRpBr0010(this.validationErrors, messageRefId, paymentDataMsgPart.getXmlReportedPayee().getCountry(), xmlReportedTransaction.getPayerMs().getType(), transactionIdentifier);
            ValidationErrorUtils.checkRtBr0030(this.validationErrors, messageRefId, reportingPeriod, xmlReportedTransaction.getDates(), transactionIdentifier);
            ValidationErrorUtils.checkRtBr0010(this.validationErrors, messageRefId, xmlReportedTransaction.isRefund(), xmlReportedTransaction.getAmount(), transactionIdentifier);
            ValidationErrorUtils.checkRtBr0040(this.validationErrors, messageRefId, this.transactionIdentifiersSet, transactionIdentifier);
            ValidationErrorUtils.checkRtBr0060(this.validationErrors, messageRefId, xmlReportedTransaction.getAmount().getValue(), transactionIdentifier);
            ValidationErrorUtils.checkRtBr0080(this.validationErrors, messageRefId, xmlReportedTransaction.isInErrorRtBr0080(), transactionIdentifier);
            ValidationErrorUtils.checkCmBr0140(this.validationErrors, messageRefId, xmlReportedTransaction.getPaymentMethodType(), Optional.ofNullable(xmlReportedTransaction.getPaymentMethodOtherId()).map(Object::toString).orElse(null), xsdVersion);
            ValidationErrorUtils.checkCmBr0130(this.validationErrors, messageRefId, xmlReportedTransaction.getPspRoleType(), Optional.ofNullable(xmlReportedTransaction.getPspRoleOtherId()).map(Object::toString).orElse(null), xsdVersion);
            ValidationErrorUtils.checkCmBr0140ForDates(this.validationErrors, messageRefId, xmlReportedTransaction.getDates(), xsdVersion);
            ValidationErrorUtils.checkRtBr0090(this.validationErrors, messageRefId, xmlReportedTransaction.isRefund(), transactionIdentifier, xmlReportedTransaction.getCorrTransactionIdentifier());
        }
    }

    public int getNumberOfTransaction() {
        return this.transactionIdentifiersSet.size();
    }

    public int getNumberOfPayees() {
        return this.docRefSet.size();
    }

    public XmlMessageSpec getXmlMessageSpec() {
        return this.xmlReader.getXmlMessageSpec();
    }
}

